function doPost(e) {
  try {
    var sheet = SpreadsheetApp.openById(
      "1mOYIhSSxkpeUg1wlNCUcVTCUBHqRyShx5rtDv_OgkCo"
    ).getActiveSheet();
    var data = JSON.parse(e.postData.contents);

    // Insert data into the sheet
    sheet.appendRow([
      new Date(),
      data.fullName || "",
      data.email || "",
      data.phone || "",
      data.organization || "",
      data.position || "",
      data.registrationType || "", // Attendee, Speaker, etc.
      data.interests || "",
      data.experience || "",
      data.dietaryRequirements || "",
      data.specialRequirements || "",
      "Registered", // Status
    ]);

    // Return success response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "success",
        message: "Registration completed successfully!",
      })
    ).setMimeType(ContentService.MimeType.JSON);
  } catch (error) {
    console.error("Error in Registration Form doPost:", error);

    // Return error response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "error",
        message: "Registration failed: " + error.toString(),
      })
    ).setMimeType(ContentService.MimeType.JSON);
  }
}

/* 
Google Sheet Headers (Row 1):
Timestamp | Full Name | Email | Phone | Organization | Position | Registration Type | Interests | Experience | Dietary Requirements | Special Requirements | Status

Deploy Settings:
- Execute as: Me
- Who has access: Anyone
- Copy the deployment URL and replace YOUR_REGISTRATION_APPS_SCRIPT_URL in the JavaScript
*/
